// DOM - Document Object Model
let btnPosalji = document.getElementById("posalji");
let btnResetuj = document.getElementById("resetuj");
let divIspis = document.getElementById("ispis");

// Dohvata sva checkBox polja sa stranice, koja imaju name = "teh"
let checkBoxPolja = document.getElementsByName("teh"); // Može i sa .querySelectorAll(input[name='teh']);

btnPosalji.addEventListener("click", (e) => {
    e.preventDefault();

    let stringZaIspis = "<ul>";
    for(let i=0; i<checkBoxPolja.length; i++) {
        let polje = checkBoxPolja[i]; // Dohvati svako polja, jer se krećemo redom nizom checkBoxPolja
        let poljeValue = polje.value; // ili let poljeValue = checkBoxPolja[i].value; Dohvata svaku vrednost iz polja
        let poljeCekirano = polje.checked; // vraća true ako je polje čekirano ili false ako polje nije čekirano
        
        if(poljeCekirano) {
            stringZaIspis += `<li>${poljeValue}</li>`;
        }
        
    }
    stringZaIspis += "</ul>";
    divIspis.innerHTML = stringZaIspis;
});

btnResetuj.addEventListener("click", () => {
    divIspis.innerHTML = "";
});